<?php
defined('_JEXEC') or die;

ArtxLoadClass("Artx_Content");

$component = new ArtxContent($this);
$article = $component->article('section');

$params = $article->getArticleViewParameters();
if ($article->titleVisible) {
    $params['header-text'] = $this->escape($article->title);
    if (strlen($article->titleLink))
        $params['header-link'] = $article->titleLink;
}
// Change the order of ""if"" statements to change the order of article metadata header items.
if ($article->showEditIcon)
    $params['metadata-header-icons'][] = $article->editIcon();
if ($article->showUrl)
    $params['metadata-header-icons'][] = $article->urlInfo();
// Build article content
$content = '';
if (!$article->isPublished)
    $content .= $article->beginUnpublishedArticle();
if (!$article->showIntro)
    $content .= $article->event('afterDisplayTitle');
$content .= $article->event('beforeDisplayContent');
$content .= $article->content();
if ($article->showReadmore)
    $content .= $article->readmore();
$content .= $article->event('afterDisplayContent');
if (!$article->isPublished)
    $content .= $article->endUnpublishedArticle();
$params['content'] = $content;

// Render article
echo $article->article($params);
